<?php
/**
 * SubscriptionStatusData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * SubscriptionStatusData Class Doc Comment
 *
 * @category Class
 * @description Stripe Subscription data for a specific domain.
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SubscriptionStatusData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SubscriptionStatusData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'domain_id' => 'string',
        'subscription_id' => 'string',
        'existing_subscriptions' => 'bool',
        'active_trial' => 'bool',
        'active_subscription' => 'bool',
        'invoice_url' => 'string',
        'invoice_amount' => 'int',
        'invoice_currency' => 'string',
        'interval' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'domain_id' => null,
        'subscription_id' => null,
        'existing_subscriptions' => null,
        'active_trial' => null,
        'active_subscription' => null,
        'invoice_url' => null,
        'invoice_amount' => 'int64',
        'invoice_currency' => null,
        'interval' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'domain_id' => false,
        'subscription_id' => false,
        'existing_subscriptions' => false,
        'active_trial' => false,
        'active_subscription' => false,
        'invoice_url' => false,
        'invoice_amount' => false,
        'invoice_currency' => false,
        'interval' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'domain_id' => 'domainId',
        'subscription_id' => 'subscriptionId',
        'existing_subscriptions' => 'existingSubscriptions',
        'active_trial' => 'activeTrial',
        'active_subscription' => 'activeSubscription',
        'invoice_url' => 'invoiceUrl',
        'invoice_amount' => 'invoiceAmount',
        'invoice_currency' => 'invoiceCurrency',
        'interval' => 'interval'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'domain_id' => 'setDomainId',
        'subscription_id' => 'setSubscriptionId',
        'existing_subscriptions' => 'setExistingSubscriptions',
        'active_trial' => 'setActiveTrial',
        'active_subscription' => 'setActiveSubscription',
        'invoice_url' => 'setInvoiceUrl',
        'invoice_amount' => 'setInvoiceAmount',
        'invoice_currency' => 'setInvoiceCurrency',
        'interval' => 'setInterval'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'domain_id' => 'getDomainId',
        'subscription_id' => 'getSubscriptionId',
        'existing_subscriptions' => 'getExistingSubscriptions',
        'active_trial' => 'getActiveTrial',
        'active_subscription' => 'getActiveSubscription',
        'invoice_url' => 'getInvoiceUrl',
        'invoice_amount' => 'getInvoiceAmount',
        'invoice_currency' => 'getInvoiceCurrency',
        'interval' => 'getInterval'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const INTERVAL_MONTHLY = 'monthly';
    public const INTERVAL_YEARLY = 'yearly';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getIntervalAllowableValues()
    {
        return [
            self::INTERVAL_MONTHLY,
            self::INTERVAL_YEARLY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('domain_id', $data ?? [], null);
        $this->setIfExists('subscription_id', $data ?? [], null);
        $this->setIfExists('existing_subscriptions', $data ?? [], null);
        $this->setIfExists('active_trial', $data ?? [], null);
        $this->setIfExists('active_subscription', $data ?? [], null);
        $this->setIfExists('invoice_url', $data ?? [], null);
        $this->setIfExists('invoice_amount', $data ?? [], null);
        $this->setIfExists('invoice_currency', $data ?? [], null);
        $this->setIfExists('interval', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['existing_subscriptions'] === null) {
            $invalidProperties[] = "'existing_subscriptions' can't be null";
        }
        if ($this->container['active_trial'] === null) {
            $invalidProperties[] = "'active_trial' can't be null";
        }
        if ($this->container['active_subscription'] === null) {
            $invalidProperties[] = "'active_subscription' can't be null";
        }
        $allowedValues = $this->getIntervalAllowableValues();
        if (!is_null($this->container['interval']) && !in_array($this->container['interval'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'interval', must be one of '%s'",
                $this->container['interval'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets domain_id
     *
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->container['domain_id'];
    }

    /**
     * Sets domain_id
     *
     * @param string|null $domain_id domain_id
     *
     * @return self
     */
    public function setDomainId($domain_id)
    {
        if (is_null($domain_id)) {
            throw new \InvalidArgumentException('non-nullable domain_id cannot be null');
        }
        $this->container['domain_id'] = $domain_id;

        return $this;
    }

    /**
     * Gets subscription_id
     *
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->container['subscription_id'];
    }

    /**
     * Sets subscription_id
     *
     * @param string|null $subscription_id subscription_id
     *
     * @return self
     */
    public function setSubscriptionId($subscription_id)
    {
        if (is_null($subscription_id)) {
            throw new \InvalidArgumentException('non-nullable subscription_id cannot be null');
        }
        $this->container['subscription_id'] = $subscription_id;

        return $this;
    }

    /**
     * Gets existing_subscriptions
     *
     * @return bool
     */
    public function getExistingSubscriptions()
    {
        return $this->container['existing_subscriptions'];
    }

    /**
     * Sets existing_subscriptions
     *
     * @param bool $existing_subscriptions existing_subscriptions
     *
     * @return self
     */
    public function setExistingSubscriptions($existing_subscriptions)
    {
        if (is_null($existing_subscriptions)) {
            throw new \InvalidArgumentException('non-nullable existing_subscriptions cannot be null');
        }
        $this->container['existing_subscriptions'] = $existing_subscriptions;

        return $this;
    }

    /**
     * Gets active_trial
     *
     * @return bool
     */
    public function getActiveTrial()
    {
        return $this->container['active_trial'];
    }

    /**
     * Sets active_trial
     *
     * @param bool $active_trial active_trial
     *
     * @return self
     */
    public function setActiveTrial($active_trial)
    {
        if (is_null($active_trial)) {
            throw new \InvalidArgumentException('non-nullable active_trial cannot be null');
        }
        $this->container['active_trial'] = $active_trial;

        return $this;
    }

    /**
     * Gets active_subscription
     *
     * @return bool
     */
    public function getActiveSubscription()
    {
        return $this->container['active_subscription'];
    }

    /**
     * Sets active_subscription
     *
     * @param bool $active_subscription active_subscription
     *
     * @return self
     */
    public function setActiveSubscription($active_subscription)
    {
        if (is_null($active_subscription)) {
            throw new \InvalidArgumentException('non-nullable active_subscription cannot be null');
        }
        $this->container['active_subscription'] = $active_subscription;

        return $this;
    }

    /**
     * Gets invoice_url
     *
     * @return string|null
     */
    public function getInvoiceUrl()
    {
        return $this->container['invoice_url'];
    }

    /**
     * Sets invoice_url
     *
     * @param string|null $invoice_url invoice_url
     *
     * @return self
     */
    public function setInvoiceUrl($invoice_url)
    {
        if (is_null($invoice_url)) {
            throw new \InvalidArgumentException('non-nullable invoice_url cannot be null');
        }
        $this->container['invoice_url'] = $invoice_url;

        return $this;
    }

    /**
     * Gets invoice_amount
     *
     * @return int|null
     */
    public function getInvoiceAmount()
    {
        return $this->container['invoice_amount'];
    }

    /**
     * Sets invoice_amount
     *
     * @param int|null $invoice_amount invoice_amount
     *
     * @return self
     */
    public function setInvoiceAmount($invoice_amount)
    {
        if (is_null($invoice_amount)) {
            throw new \InvalidArgumentException('non-nullable invoice_amount cannot be null');
        }
        $this->container['invoice_amount'] = $invoice_amount;

        return $this;
    }

    /**
     * Gets invoice_currency
     *
     * @return string|null
     */
    public function getInvoiceCurrency()
    {
        return $this->container['invoice_currency'];
    }

    /**
     * Sets invoice_currency
     *
     * @param string|null $invoice_currency invoice_currency
     *
     * @return self
     */
    public function setInvoiceCurrency($invoice_currency)
    {
        if (is_null($invoice_currency)) {
            throw new \InvalidArgumentException('non-nullable invoice_currency cannot be null');
        }
        $this->container['invoice_currency'] = $invoice_currency;

        return $this;
    }

    /**
     * Gets interval
     *
     * @return string|null
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     *
     * @param string|null $interval As part of a Stripe Subscription (or checkout session), to indicate the payment interval.
     *
     * @return self
     */
    public function setInterval($interval)
    {
        if (is_null($interval)) {
            throw new \InvalidArgumentException('non-nullable interval cannot be null');
        }
        $allowedValues = $this->getIntervalAllowableValues();
        if (!in_array($interval, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'interval', must be one of '%s'",
                    $interval,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['interval'] = $interval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


