<?php
/**
 * SubscriptionApi
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use cnb\api\ApiException;
use cnb\api\Configuration;
use cnb\api\HeaderSelector;
use cnb\api\ObjectSerializer;

/**
 * SubscriptionApi Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SubscriptionApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createCheckoutSession' => [
            'application/json',
        ],
        'createProAccountCheckoutSession' => [
            'application/json',
        ],
        'getCheckoutSession' => [
            'application/json',
        ],
        'getSubscriptionStatusForDomain' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createCheckoutSession
     *
     * Create a Stripe Checkout session. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\CheckoutSessionCreateRequest $checkout_session_create_request checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCheckoutSession'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\CheckoutSessionResponse
     */
    public function createCheckoutSession($checkout_session_create_request, string $contentType = self::contentTypes['createCheckoutSession'][0])
    {
        list($response) = $this->createCheckoutSessionWithHttpInfo($checkout_session_create_request, $contentType);
        return $response;
    }

    /**
     * Operation createCheckoutSessionWithHttpInfo
     *
     * Create a Stripe Checkout session. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\CheckoutSessionCreateRequest $checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCheckoutSession'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\CheckoutSessionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCheckoutSessionWithHttpInfo($checkout_session_create_request, string $contentType = self::contentTypes['createCheckoutSession'][0])
    {
        $request = $this->createCheckoutSessionRequest($checkout_session_create_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\CheckoutSessionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\CheckoutSessionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\CheckoutSessionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\CheckoutSessionResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\CheckoutSessionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCheckoutSessionAsync
     *
     * Create a Stripe Checkout session. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\CheckoutSessionCreateRequest $checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCheckoutSessionAsync($checkout_session_create_request, string $contentType = self::contentTypes['createCheckoutSession'][0])
    {
        return $this->createCheckoutSessionAsyncWithHttpInfo($checkout_session_create_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCheckoutSessionAsyncWithHttpInfo
     *
     * Create a Stripe Checkout session. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\CheckoutSessionCreateRequest $checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCheckoutSessionAsyncWithHttpInfo($checkout_session_create_request, string $contentType = self::contentTypes['createCheckoutSession'][0])
    {
        $returnType = '\cnb\api\Model\CheckoutSessionResponse';
        $request = $this->createCheckoutSessionRequest($checkout_session_create_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCheckoutSession'
     *
     * @param  \cnb\api\Model\CheckoutSessionCreateRequest $checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCheckoutSessionRequest($checkout_session_create_request, string $contentType = self::contentTypes['createCheckoutSession'][0])
    {

        // verify the required parameter 'checkout_session_create_request' is set
        if ($checkout_session_create_request === null || (is_array($checkout_session_create_request) && count($checkout_session_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $checkout_session_create_request when calling createCheckoutSession'
            );
        }


        $resourcePath = '/v1/subscription/v2';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($checkout_session_create_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($checkout_session_create_request));
            } else {
                $httpBody = $checkout_session_create_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createProAccountCheckoutSession
     *
     * Create a Stripe Checkout session for a PRO Account. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\ProAccountCheckoutSessionCreateRequest $pro_account_checkout_session_create_request pro_account_checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProAccountCheckoutSession'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ProAccountCheckoutSessionResponse
     */
    public function createProAccountCheckoutSession($pro_account_checkout_session_create_request, string $contentType = self::contentTypes['createProAccountCheckoutSession'][0])
    {
        list($response) = $this->createProAccountCheckoutSessionWithHttpInfo($pro_account_checkout_session_create_request, $contentType);
        return $response;
    }

    /**
     * Operation createProAccountCheckoutSessionWithHttpInfo
     *
     * Create a Stripe Checkout session for a PRO Account. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\ProAccountCheckoutSessionCreateRequest $pro_account_checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProAccountCheckoutSession'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ProAccountCheckoutSessionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProAccountCheckoutSessionWithHttpInfo($pro_account_checkout_session_create_request, string $contentType = self::contentTypes['createProAccountCheckoutSession'][0])
    {
        $request = $this->createProAccountCheckoutSessionRequest($pro_account_checkout_session_create_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ProAccountCheckoutSessionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ProAccountCheckoutSessionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ProAccountCheckoutSessionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ProAccountCheckoutSessionResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ProAccountCheckoutSessionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createProAccountCheckoutSessionAsync
     *
     * Create a Stripe Checkout session for a PRO Account. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\ProAccountCheckoutSessionCreateRequest $pro_account_checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProAccountCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProAccountCheckoutSessionAsync($pro_account_checkout_session_create_request, string $contentType = self::contentTypes['createProAccountCheckoutSession'][0])
    {
        return $this->createProAccountCheckoutSessionAsyncWithHttpInfo($pro_account_checkout_session_create_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createProAccountCheckoutSessionAsyncWithHttpInfo
     *
     * Create a Stripe Checkout session for a PRO Account. Default is a redirect to the Hosted Checkout Page.
     *
     * @param  \cnb\api\Model\ProAccountCheckoutSessionCreateRequest $pro_account_checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProAccountCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProAccountCheckoutSessionAsyncWithHttpInfo($pro_account_checkout_session_create_request, string $contentType = self::contentTypes['createProAccountCheckoutSession'][0])
    {
        $returnType = '\cnb\api\Model\ProAccountCheckoutSessionResponse';
        $request = $this->createProAccountCheckoutSessionRequest($pro_account_checkout_session_create_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createProAccountCheckoutSession'
     *
     * @param  \cnb\api\Model\ProAccountCheckoutSessionCreateRequest $pro_account_checkout_session_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProAccountCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createProAccountCheckoutSessionRequest($pro_account_checkout_session_create_request, string $contentType = self::contentTypes['createProAccountCheckoutSession'][0])
    {

        // verify the required parameter 'pro_account_checkout_session_create_request' is set
        if ($pro_account_checkout_session_create_request === null || (is_array($pro_account_checkout_session_create_request) && count($pro_account_checkout_session_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pro_account_checkout_session_create_request when calling createProAccountCheckoutSession'
            );
        }


        $resourcePath = '/v1/subscription/proAccount';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pro_account_checkout_session_create_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pro_account_checkout_session_create_request));
            } else {
                $httpBody = $pro_account_checkout_session_create_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCheckoutSession
     *
     * Get a Stripe Checkout session
     *
     * @param  string $checkout_session_id checkout_session_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCheckoutSession'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\CheckoutSessionStatusResponse
     */
    public function getCheckoutSession($checkout_session_id, string $contentType = self::contentTypes['getCheckoutSession'][0])
    {
        list($response) = $this->getCheckoutSessionWithHttpInfo($checkout_session_id, $contentType);
        return $response;
    }

    /**
     * Operation getCheckoutSessionWithHttpInfo
     *
     * Get a Stripe Checkout session
     *
     * @param  string $checkout_session_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCheckoutSession'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\CheckoutSessionStatusResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCheckoutSessionWithHttpInfo($checkout_session_id, string $contentType = self::contentTypes['getCheckoutSession'][0])
    {
        $request = $this->getCheckoutSessionRequest($checkout_session_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\CheckoutSessionStatusResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\CheckoutSessionStatusResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\CheckoutSessionStatusResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\CheckoutSessionStatusResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\CheckoutSessionStatusResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCheckoutSessionAsync
     *
     * Get a Stripe Checkout session
     *
     * @param  string $checkout_session_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCheckoutSessionAsync($checkout_session_id, string $contentType = self::contentTypes['getCheckoutSession'][0])
    {
        return $this->getCheckoutSessionAsyncWithHttpInfo($checkout_session_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCheckoutSessionAsyncWithHttpInfo
     *
     * Get a Stripe Checkout session
     *
     * @param  string $checkout_session_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCheckoutSessionAsyncWithHttpInfo($checkout_session_id, string $contentType = self::contentTypes['getCheckoutSession'][0])
    {
        $returnType = '\cnb\api\Model\CheckoutSessionStatusResponse';
        $request = $this->getCheckoutSessionRequest($checkout_session_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCheckoutSession'
     *
     * @param  string $checkout_session_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCheckoutSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCheckoutSessionRequest($checkout_session_id, string $contentType = self::contentTypes['getCheckoutSession'][0])
    {

        // verify the required parameter 'checkout_session_id' is set
        if ($checkout_session_id === null || (is_array($checkout_session_id) && count($checkout_session_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $checkout_session_id when calling getCheckoutSession'
            );
        }


        $resourcePath = '/v1/subscription/session/{checkoutSessionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($checkout_session_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkoutSessionId' . '}',
                ObjectSerializer::toPathValue($checkout_session_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSubscriptionStatusForDomain
     *
     * Get subscription status for a domain
     *
     * @param  string $domain_id domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionStatusForDomain'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\SubscriptionStatusData
     */
    public function getSubscriptionStatusForDomain($domain_id, string $contentType = self::contentTypes['getSubscriptionStatusForDomain'][0])
    {
        list($response) = $this->getSubscriptionStatusForDomainWithHttpInfo($domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getSubscriptionStatusForDomainWithHttpInfo
     *
     * Get subscription status for a domain
     *
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionStatusForDomain'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\SubscriptionStatusData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriptionStatusForDomainWithHttpInfo($domain_id, string $contentType = self::contentTypes['getSubscriptionStatusForDomain'][0])
    {
        $request = $this->getSubscriptionStatusForDomainRequest($domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\SubscriptionStatusData' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\SubscriptionStatusData' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\SubscriptionStatusData', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\SubscriptionStatusData';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\SubscriptionStatusData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSubscriptionStatusForDomainAsync
     *
     * Get subscription status for a domain
     *
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionStatusForDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionStatusForDomainAsync($domain_id, string $contentType = self::contentTypes['getSubscriptionStatusForDomain'][0])
    {
        return $this->getSubscriptionStatusForDomainAsyncWithHttpInfo($domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSubscriptionStatusForDomainAsyncWithHttpInfo
     *
     * Get subscription status for a domain
     *
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionStatusForDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionStatusForDomainAsyncWithHttpInfo($domain_id, string $contentType = self::contentTypes['getSubscriptionStatusForDomain'][0])
    {
        $returnType = '\cnb\api\Model\SubscriptionStatusData';
        $request = $this->getSubscriptionStatusForDomainRequest($domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSubscriptionStatusForDomain'
     *
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionStatusForDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSubscriptionStatusForDomainRequest($domain_id, string $contentType = self::contentTypes['getSubscriptionStatusForDomain'][0])
    {

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getSubscriptionStatusForDomain'
            );
        }


        $resourcePath = '/v1/subscription/domain/{domainId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
